const express  = require('express');
const dotenv  = require('dotenv');
const path = require('path');
const fs = require('fs');
const indexRoute = require('./api/indexRoutes')

dotenv.config()
const app = express();
const port = process.env.PORT || 3100

app.use(express.static(path.join(__dirname,"build")));

app.use('/api/',indexRoute);


app.use('/*',(req, res)=>{
    fs.readFile('./build/index.html','utf8',(err,data)=>{
        if (err){
            console.log(err)
        }else{
            res.send(data);
        }
    }) ;
})

app.listen(port,()=>{
    console.log(`Listening on ${port}`)
})