const Axios = require("axios");
const router = require('express').Router()

const fs  = require('fs');

router.get('/currency/:currency',(req, res)=> {
     let config = {
            method: 'GET',
            url: `https://api.flutterwave.com/v3/transfers/rates?amount=1&destination_currency=USD&source_currency=${req.params.currency}`,
            headers: {
                'Authorization': `Bearer ${process.env.TOKEN}`
            }
        };
        Axios(config)
            .then(result=>{
                // console.log(result.data)
                let v = parseFloat((result.data.data.rate).toFixed(2));
                res.send({data:v})


            })
            .catch(err=>{

                res.status(500).send({msg:"Failed"})
            })
})
router.get('/country/:ipAddress',(req,res)=>{
    console.log(req.params)
    Axios.get(`https://api.country.is/${req.params.ipAddress}`)
        .then(country=>{
            const countries =  JSON.parse(fs.readFileSync(__dirname  + "\/countries.json",{encoding:'utf-8'})).countries.country;

            const index = countries.findIndex(e=>e["countryCode"]===country.data.country);

            res.send({data: countries[index]})
        })
        .catch(err=>{
            console.log(err)
            res.status(500).send({msg:"111 Internal server error"})
        })
})





module.exports = router;